/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWHasFault;
import filenet.vw.api.IVWHasWSParameterDefs;
import filenet.vw.api.VWActionType;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFaultDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWInvokeInstruction
extends VWInstructionDefinition
implements Serializable,
IVWHasWSParameterDefs,
IVWHasFault {
    private static final long serialVersionUID = 7491L;
    private String m_PartnerLinkName = null;
    private String m_InputMsgExpr = null;
    private String m_OutputMsgExpr = null;
    private String m_OperationName = null;
    private String m_InputMsgName = null;
    private String m_OutputMsgName = null;
    private String m_TimeoutExpr = null;
    private String m_TimeoutMap = null;
    private VWFaultDefinition m_CatchAll = null;
    private VWWebServiceParameterDefinition[] m_InComingParameters = null;
    private VWArrayHandler m_InComingParametersHandler = new VWArrayHandler();
    private VWWebServiceParameterDefinition[] m_OutGoingParameters = null;
    private VWArrayHandler m_OutGoingParametersHandler = new VWArrayHandler();
    private String m_InputCorrelationSetName = null;
    private String[][] m_InputCorrelationSetProperties = null;
    private String m_OutputCorrelationSetName = null;
    private String[][] m_OutputCorrelationSetProperties = null;
    private VWFaultDefinition[] m_Faults = null;
    private VWArrayHandler m_FaultsHandler = new VWArrayHandler(5, 5);
    private boolean m_UseReliableMessaging = false;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-10-13 16:28:08 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/9 $";
    }

    protected VWInvokeInstruction(VWCompoundStepDefinition CompStep, int theInstructionId) throws VWException {
        super(CompStep, theInstructionId, 39);
    }

    protected VWInvokeInstruction(VWCompoundStepDefinition CompStep, int theInstructionId, String thePartnerLinkName, String theOperationName) throws VWException {
        super(CompStep, theInstructionId, 39);
        this.setPartnerLinkName(thePartnerLinkName);
        this.setOperationName(theOperationName);
    }

    public VWFaultDefinition createFault(String theName, String theFaultMessage, String theFaultMapName) throws VWException {
        VWFaultDefinition newFault = new VWFaultDefinition(this, theName, theFaultMessage, theFaultMapName);
        this.m_Faults = (VWFaultDefinition[])this.m_FaultsHandler.addElementToArray(this.m_Faults, newFault);
        return newFault;
    }

    public void setCatchAllOutput(String theOutput) throws VWException {
        if (this.m_CatchAll == null) {
            this.m_CatchAll = new VWFaultDefinition(this, "CatchAll", null, null);
        }
        this.m_CatchAll.setFaultMessage((String)(theOutput != null && theOutput.equals("") ? null : theOutput));
        if (this.m_CatchAll.getFaultMapName() == null && this.m_CatchAll.getFaultMessage() == null) {
            this.m_CatchAll = null;
        }
    }

    public void setCatchAllMap(String theMapName) throws VWException {
        if (this.m_CatchAll == null) {
            this.m_CatchAll = new VWFaultDefinition(this, "CatchAll", null, null);
        }
        this.m_CatchAll.setFaultMapName((String)(theMapName != null && theMapName.equals("") ? null : theMapName));
        if (this.m_CatchAll.getFaultMapName() == null && this.m_CatchAll.getFaultMessage() == null) {
            this.m_CatchAll = null;
        }
    }

    public VWFaultDefinition getCatchAllFault() throws VWException {
        return this.m_CatchAll;
    }

    public String getCatchAllMap() throws VWException {
        if (this.m_CatchAll == null) {
            return null;
        }
        return this.m_CatchAll.getFaultMapName();
    }

    public String getCatchAllMessage() throws VWException {
        if (this.m_CatchAll == null) {
            return null;
        }
        return this.m_CatchAll.getFaultMessage();
    }

    public VWFaultDefinition[] getFaults() throws VWException {
        return (VWFaultDefinition[])this.m_FaultsHandler.getElements(this.m_Faults);
    }

    public void setFaults(VWFaultDefinition[] theFaults) throws VWException {
        int arrayLen;
        int n = arrayLen = theFaults != null ? theFaults.length : 0;
        if (theFaults != null) {
            for (int i = 0; i < arrayLen; ++i) {
                if (theFaults[i] != null) continue;
                throw new VWException("vw.api.VWInvokeInstructionNullElementInEventArray", "theFaultss contains a null element at index{0}.", String.valueOf(i));
            }
        }
        this.m_Faults = theFaults;
        this.m_FaultsHandler.setElementCount(arrayLen);
    }

    public VWFaultDefinition getFault(String theName) throws VWException {
        int index = this.m_FaultsHandler.getIndexFromStringFieldValue(this.m_Faults, "m_Name", theName);
        if (index == -1) {
            throw new VWException("vw.api.VWInvokeInstructionFaultNotFound", "No fault found with name equal to {0} in this invoke instruction.", theName);
        }
        return this.m_Faults[index];
    }

    public void setTimeoutExpr(String theTimeoutExpr) throws VWException {
        this.m_TimeoutExpr = theTimeoutExpr;
    }

    public String getTimeoutExpr() {
        return this.m_TimeoutExpr;
    }

    public void setTimeoutMapName(String theTimeoutMapName) throws VWException {
        this.m_TimeoutMap = theTimeoutMapName;
    }

    public String getTimeoutMapName() {
        return this.m_TimeoutMap;
    }

    public void setInputMsgExpr(String theInputMsgExpr) throws VWException {
        this.m_InputMsgExpr = theInputMsgExpr;
    }

    public String getInputMsgExpr() {
        return this.m_InputMsgExpr;
    }

    public void setOutputMsgExpr(String theOutputMsgExpr) throws VWException {
        this.m_OutputMsgExpr = theOutputMsgExpr;
    }

    public String getOutputMsgExpr() {
        return this.m_OutputMsgExpr;
    }

    public void setPartnerLinkName(String thePartnerLinkName) throws VWException {
        this.m_PartnerLinkName = thePartnerLinkName;
    }

    public String getPartnerLinkName() {
        return this.m_PartnerLinkName;
    }

    public void setOperationName(String theOperationName) throws VWException {
        this.m_OperationName = theOperationName;
    }

    public String getOperationName() {
        return this.m_OperationName;
    }

    public VWWebServiceParameterDefinition createInComingParameter(String theName, String theValue, int theType, boolean theIsArray) throws VWException {
        VWWebServiceParameterDefinition newParameter = new VWWebServiceParameterDefinition(this, theName, 2, theType, theIsArray, theValue);
        this.m_InComingParameters = (VWWebServiceParameterDefinition[])this.m_InComingParametersHandler.addElementToArray(this.m_InComingParameters, newParameter);
        return newParameter;
    }

    public VWWebServiceParameterDefinition createOutGoingParameter(String theName, String theValue, int theType, boolean theIsArray) throws VWException {
        VWWebServiceParameterDefinition newParameter = new VWWebServiceParameterDefinition(this, theName, 1, theType, theIsArray, theValue);
        this.m_OutGoingParameters = (VWWebServiceParameterDefinition[])this.m_OutGoingParametersHandler.addElementToArray(this.m_OutGoingParameters, newParameter);
        return newParameter;
    }

    public void deleteOutGoingParameter(int theSequenceNumber) throws VWException {
        int index = this.m_OutGoingParametersHandler.getIndexFromIntFieldValue(this.m_OutGoingParameters, "m_Sequence", theSequenceNumber);
        if (index == -1) {
            throw new VWException("vw.api.VWInvokeInstructionOutgoingParameterNotFound", "No Out Going parameter found with sequence number equal to {0} in invoke instruction.", String.valueOf(theSequenceNumber));
        }
        this.m_OutGoingParametersHandler.deleteElementFromArray(this.m_OutGoingParameters, index);
    }

    public void deleteInComingParameter(int theSequenceNumber) throws VWException {
        int index = this.m_InComingParametersHandler.getIndexFromIntFieldValue(this.m_InComingParameters, "m_Sequence", theSequenceNumber);
        if (index == -1) {
            throw new VWException("vw.api.VWInvokeInstructionIncomingParameterNotFound", "No in coming parameter found with sequence number equal to {0} in invoke instruction.", String.valueOf(theSequenceNumber));
        }
        this.m_InComingParametersHandler.deleteElementFromArray(this.m_InComingParameters, index);
    }

    public void deleteAllParameters() throws VWException {
        this.m_InComingParametersHandler = new VWArrayHandler();
        this.m_InComingParameters = null;
        this.m_OutGoingParametersHandler = new VWArrayHandler();
        this.m_OutGoingParameters = null;
    }

    public void deleteAllInComingParameters() throws VWException {
        this.m_InComingParametersHandler = new VWArrayHandler();
        this.m_InComingParameters = null;
    }

    public void deleteAllOutGoingParameters() throws VWException {
        this.m_OutGoingParametersHandler = new VWArrayHandler();
        this.m_OutGoingParameters = null;
    }

    public VWWebServiceParameterDefinition getOutGoingParameterDefinition(int theSequenceNumber) throws VWException {
        int index = this.m_OutGoingParametersHandler.getIndexFromIntFieldValue(this.m_OutGoingParameters, "m_Sequence", theSequenceNumber);
        if (index == -1) {
            throw new VWException("vw.api.VWInvokeInstructionOutGoingParameterNotFound", "No out going parameter found with sequence number equal to {0} in invoke instruction.", String.valueOf(theSequenceNumber));
        }
        return this.m_OutGoingParameters[index];
    }

    public VWWebServiceParameterDefinition getInComingParameterDefinition(int theSequenceNumber) throws VWException {
        int index = this.m_InComingParametersHandler.getIndexFromIntFieldValue(this.m_InComingParameters, "m_Sequence", theSequenceNumber);
        if (index == -1) {
            throw new VWException("vw.api.VWInvokeInstructionInComingParameterNotFound", "No in coming parameter found with sequence number equal to {0} in invoke instruction.", String.valueOf(theSequenceNumber));
        }
        return this.m_InComingParameters[index];
    }

    public VWWebServiceParameterDefinition[] getOutGoingParameterDefinitions() throws VWException {
        return (VWWebServiceParameterDefinition[])this.m_OutGoingParametersHandler.getElements(this.m_OutGoingParameters);
    }

    public VWWebServiceParameterDefinition[] getInComingParameterDefinitions() throws VWException {
        return (VWWebServiceParameterDefinition[])this.m_InComingParametersHandler.getElements(this.m_InComingParameters);
    }

    public String toString() {
        String retVal = "";
        try {
            retVal = VWActionType.typeToString(this.action);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public void validate(VWSession theSession, Vector EDefVector, VWCompoundStepDefinition myStep) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext, myStep);
    }

    protected void validate(VWValidationContext validationContext, VWCompoundStepDefinition myStep) throws VWException {
        VWWebServiceParameterDefinition[] pOut;
        VWValidationError theError;
        VWFaultDefinition[] f;
        VWValidationError theError2;
        VWValidationError theError3;
        block54: {
            VWString theMessage;
            int i;
            int errorCount;
            String[] theErrorStrings;
            VWCompiledExpr compRes;
            VWValidationError theError4;
            VWString theMessage2;
            VWWorkflowSignature myWflSignature = myStep.getMap().getWorkflow().getWorkflowSignature(validationContext);
            VWWorkflowSignature myBaseWflSignature = myStep.getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
            if (this.m_PartnerLinkName == null || !myStep.getMap().getWorkflow().isExistingPartnerLinkName(this.m_PartnerLinkName) && !myBaseWflSignature.isPartnerlinkName(this.m_PartnerLinkName)) {
                theMessage2 = new VWString("vw.api.VWInvokeInstructionBadPartnerLinkName", "Partner link name, {0}, is not the name of a partner link in this workflow definition.", this.m_PartnerLinkName);
                theError4 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError4);
            }
            if (this.m_OperationName == null || this.m_OperationName == "") {
                theMessage2 = new VWString("vw.api.VWInvokeInstructionBadOperationName", "Operation name is null or empty");
                theError4 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError4);
            }
            if (this.m_InputMsgExpr != null) {
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.m_InputMsgExpr, myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    errorCount = theErrorStrings.length;
                    for (i = 0; i < errorCount; ++i) {
                        theMessage = new VWString("vw.api.VWInvokeInstructionSyntaxErrorInInputMessageExpr", "Syntax error in input message expression of invoke instruction (expected string expression) : {0}", theErrorStrings[i]);
                        theError3 = new VWValidationError(7, 1, myStep.getName(), this.m_InputMsgExpr, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError3);
                    }
                } else if (compRes.getResultIsArray() || compRes.getResultType() != 2 && compRes.getResultType() != 128) {
                    VWString theMessage3 = new VWString("vw.api.VWInvokeInstructionInputMessageNotString", "Input message expression parameter must be an string expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() ? "[ ]" : ""));
                    VWValidationError theError5 = new VWValidationError(7, 1, myStep.getName(), this.m_InputMsgExpr, theMessage3.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError5);
                }
            }
            if (this.m_OutputMsgExpr != null) {
                compRes = new VWCompiledRefExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.m_OutputMsgExpr, myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    errorCount = theErrorStrings.length;
                    for (i = 0; i < errorCount; ++i) {
                        theMessage = new VWString("vw.api.VWInvokeInstructionSyntaxErrorInOutputMessageExpr", "Syntax error in output message expression of invoke instruction (expected string expression, left side value, i.e. it must be assignable) : {0}", theErrorStrings[i]);
                        theError3 = new VWValidationError(7, 1, myStep.getName(), this.m_OutputMsgExpr, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError3);
                    }
                } else if (compRes.getResultIsArray() || compRes.getResultType() != 2 && compRes.getResultType() != 128) {
                    VWString theMessage4 = new VWString("vw.api.VWInvokeInstructionOutputMessageNotString", "Output message expression must be an string expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() ? "[ ]" : ""));
                    VWValidationError theError6 = new VWValidationError(7, 1, myStep.getName(), this.m_OutputMsgExpr, theMessage4.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError6);
                }
            }
            if (this.m_TimeoutExpr != null && this.m_TimeoutExpr.compareTo("") == 0) {
                theMessage2 = new VWString("vw.api.VWInvokeInstructionTimeOutIsNull", "Time Out value is empty, it must be null or a valid time expression");
                theError4 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError4);
            }
            if (this.m_TimeoutExpr != null && this.m_TimeoutExpr.compareTo("") != 0 && (this.m_TimeoutMap == null || this.m_TimeoutMap.compareTo("") == 0)) {
                theMessage2 = new VWString("vw.api.VWInvokeInstructionTimeOutExprButNoTimeOutMap", "Time out expression is set, but the time out map is set to none.  If either time out expression or time out map is set, then both must must be set to valid values.");
                theError4 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError4);
            }
            if (this.m_TimeoutMap != null && this.m_TimeoutMap.compareTo("") != 0 && (this.m_TimeoutExpr == null || this.m_TimeoutExpr.compareTo("") == 0)) {
                theMessage2 = new VWString("vw.api.VWInvokeInstructionTimeOutMapButNoTimeOutExpr", "Time out map is set, but the time out expression is set to none.  If either time out expression or time out map is set, then both must must be set to valid values.");
                theError4 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError4);
            }
            if (this.m_TimeoutExpr != null && this.m_TimeoutExpr.compareTo("") != 0 && this.m_TimeoutExpr.trim().compareTo("0") != 0) {
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.m_TimeoutExpr, myWflSignature, myBaseWflSignature, null, null, true, compRes);
                int errorCount2 = 0;
                if (theErrorStrings != null) {
                    errorCount2 = theErrorStrings.length;
                    for (int i2 = 0; i2 < errorCount2; ++i2) {
                        theMessage = new VWString("vw.api.VWInvokeInstructionTimeOutSyntaxError", "Time Out value: {0}", theErrorStrings[i2]);
                        theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError3);
                    }
                } else if (compRes.getResultIsArray() || compRes.getResultType() != 16) {
                    VWString theMessage5 = new VWString("vw.api.VWWFEInstructionTimeOutNotTime", "Time Out value expression must be a time expression, found a {0}{1}.", VWFieldType.typeToString(compRes.getResultType()), compRes.getResultIsArray() ? "[ ]" : "");
                    theError2 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage5.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError2);
                }
            }
            if (this.m_TimeoutMap != null && VWMapDefinition.mapNameToId(this.m_TimeoutMap) == 0) {
                try {
                    myStep.getMap().getWorkflow().getMap(this.m_TimeoutMap);
                }
                catch (Exception e) {
                    if (myBaseWflSignature != null && myBaseWflSignature.isInstructionSheetName(this.m_TimeoutMap)) break block54;
                    VWString theMessage6 = new VWString("vw.api.VWInvokeInstructionTimeoutMapNotFound", "The timeout map map, {0}, was not found in this workflow definition.", this.m_TimeoutMap);
                    VWValidationError theError7 = new VWValidationError(7, 1, myStep.getName(), this.m_TimeoutMap, theMessage6.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstructionId());
                    validationContext.addValidationError(theError7);
                }
            }
        }
        if ((f = this.getFaults()) != null) {
            for (int i = 0; i < f.length; ++i) {
                f[i].validate(validationContext, myStep, this.getInstructionId(), i);
            }
        }
        if (this.m_CatchAll != null) {
            this.m_CatchAll.validate(validationContext, myStep, this.getInstructionId(), -99);
        }
        boolean atLeastOneAttachmentParamByValue = false;
        VWWebServiceParameterDefinition[] pIn = this.getInComingParameterDefinitions();
        if (pIn != null) {
            for (int i = 0; i < pIn.length; ++i) {
                pIn[i].validate(validationContext, myStep);
                if (!pIn[i].isAttachmentByValue()) continue;
                atLeastOneAttachmentParamByValue = true;
            }
        }
        if (atLeastOneAttachmentParamByValue && myStep.getMap().getWorkflow().getIncomingWSAttachmentFolder() == null) {
            VWString theMessage = new VWString("vw.api.VWInvokeInstructionIncomingAttachmentByValueNoIncomingAttachmentFolder", "At least one parameter in this receive instruction is an incoming attachment by value but there is no incoming attachment folder value set in the workflow.");
            theError2 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
            validationContext.addValidationError(theError2);
        }
        if (pIn != null) {
            VWString theMessage;
            int i;
            boolean[] seqNumFound = new boolean[pIn.length];
            for (i = 0; i < pIn.length; ++i) {
                if (pIn[i].getSequenceNumber() < 0 || pIn[i].getSequenceNumber() >= pIn.length) {
                    theMessage = new VWString("vw.api.VWInvokeInstructionIncomingParamSeqNumberOutOfRange", "Invoke instruction incoming parameter named {0} has sequence number {1}, which outside the range 0-{2}.", pIn[i].getName(), String.valueOf(pIn[i].getSequenceNumber()), String.valueOf(pIn.length - 1));
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                    continue;
                }
                if (seqNumFound[pIn[i].getSequenceNumber()]) {
                    theMessage = new VWString("vw.api.VWInvokeInstructionIncomingParamDuplicateSeqNumber", "Invoke instruction incoming parameter named {0} has sequence number {1}, which is already in use by parameter named {2} in this invoke instruction.", pIn[i].getName(), String.valueOf(pIn[i].getSequenceNumber()), this.getInComingParameterDefinition(i).getName());
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                    continue;
                }
                seqNumFound[pIn[i].getSequenceNumber()] = true;
            }
            for (i = 0; i < pIn.length; ++i) {
                seqNumFound[i] = false;
                if (!false) continue;
                theMessage = new VWString("vw.api.VWInvokeInstructionIncomingParamGapInSeqNumbers", "Invoke instruction sequence number {0}, should be used in the incoming parameters of this invoke instruction but no parameter was found with that sequence number.", String.valueOf(i));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
            }
        }
        if (pIn != null && pIn.length != 0) {
            if (pIn[0].getLexicalLevel() != 0) {
                VWWebServiceParameterDefinition pDef = null;
                try {
                    pDef = this.getInComingParameterDefinition(0);
                }
                catch (Exception e) {
                    // empty catch block
                }
                VWString theMessage = new VWString("vw.api.VWInvokeInstructionIncomingParamSeqNumberZeroArrayNotLexLvlZero", "Invoke instruction incoming parameter named, {0}, with sequence number 0, must have lexical level 0, found lexical level {1}.", pDef != null ? pDef.getName() : "<< name not found - probably missing parameter with sequence number 0 >>", pDef != null ? String.valueOf(pDef.getLexicalLevel()) : "unknown");
                theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError3);
            } else {
                for (int i = 1; i < pIn.length; ++i) {
                    if (pIn[i].getLexicalLevel() >= 0 && pIn[i].getLexicalLevel() <= this.getInComingParameterDefinition(pIn[i].getSequenceNumber() - 1).getLexicalLevel() + 1) continue;
                    VWString theMessage = new VWString("vw.api.VWInvokeInstructionIncomingParamLexLvlInconsistency", "Invoke instruction incoming parameter named, {0}, has lexical level {1}, expected lexical level in the range 0 - {2}.", this.getInComingParameterDefinition(i).getName() + " (seq. # " + String.valueOf(this.getInComingParameterDefinition(i).getSequenceNumber()) + ") ", String.valueOf(this.getInComingParameterDefinition(i).getLexicalLevel()), String.valueOf(this.getInComingParameterDefinition(pIn[i].getSequenceNumber() - 1).getLexicalLevel() + 1));
                    theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError3);
                }
            }
        }
        if ((pOut = this.getOutGoingParameterDefinitions()) != null) {
            for (int i = 0; i < pOut.length; ++i) {
                pOut[i].validate(validationContext, myStep);
            }
        }
        if (pOut != null) {
            VWValidationError theError8;
            VWString theMessage;
            int i;
            boolean[] seqNumFound = new boolean[pOut.length];
            for (i = 0; i < pOut.length; ++i) {
                if (pOut[i].getSequenceNumber() < 0 || pOut[i].getSequenceNumber() >= pOut.length) {
                    theMessage = new VWString("vw.api.VWInvokeInstructionOutGoingParamSeqNumberOutOfRange", "Invoke instruction outgoing parameter named {0} has sequence number {1}, which outside the expected range 0-{2}.", pOut[i].getName(), String.valueOf(pOut[i].getSequenceNumber()), String.valueOf(pOut.length - 1));
                    theError8 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError8);
                    continue;
                }
                if (seqNumFound[pOut[i].getSequenceNumber()]) {
                    theMessage = new VWString("vw.api.VWInvokeInstructionOutGoingParamDuplicateSeqNumber", "Invoke instruction outgoing parameter named {0} has sequence number {1}, which is already in use by parameter named {2} in this invoke instruction.", pOut[i].getName(), String.valueOf(pOut[i].getSequenceNumber()), this.getInComingParameterDefinition(i).getName());
                    theError8 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError8);
                    continue;
                }
                seqNumFound[pOut[i].getSequenceNumber()] = true;
            }
            for (i = 0; i < pOut.length; ++i) {
                seqNumFound[i] = false;
                if (!false) continue;
                theMessage = new VWString("vw.api.VWInvokeInstructionOutGoingParamGapInSeqNumber", "Invoke instruction sequence number {0}, should occur in the outgoing parameters of this invoke instruction but no parameter was found with that sequence number.", String.valueOf(i));
                theError8 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError8);
            }
        }
        if (pOut != null && pOut.length != 0) {
            if (pOut[0].getLexicalLevel() != 0) {
                VWWebServiceParameterDefinition pDef = null;
                try {
                    pDef = this.getOutGoingParameterDefinition(0);
                }
                catch (Exception e) {
                    // empty catch block
                }
                VWString theMessage = new VWString("vw.api.VWInvokeInstructionOutGoingParamSeqNumberZeroArrayNotLexLvlZero", "Invoke instruction outgoing parameter named, {0}, with sequence number 0, must have lexical level 0, found lexical level {1}.", pDef != null ? pDef.getName() : "<< name not found - probably missing parameter with sequence number 0 >>", pDef != null ? String.valueOf(pDef.getLexicalLevel()) : "unknown");
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
            } else {
                for (int i = 1; i < pOut.length; ++i) {
                    if (pOut[i].getLexicalLevel() >= 0 && pOut[i].getLexicalLevel() <= this.getOutGoingParameterDefinition(pOut[i].getSequenceNumber() - 1).getLexicalLevel() + 1) continue;
                    VWString theMessage = new VWString("vw.api.VWInvokeInstructionOutGoingParamLexLvlInconsistency", "Invoke instruction outgoing parameter named, {0}, has lexical level {1}, expected lexical level in the range 0 - {2}.", this.getOutGoingParameterDefinition(i).getName() + " (seq. # " + String.valueOf(this.getOutGoingParameterDefinition(i).getSequenceNumber()) + ") ", String.valueOf(this.getOutGoingParameterDefinition(i).getLexicalLevel()), String.valueOf(this.getOutGoingParameterDefinition(pOut[i].getSequenceNumber() - 1).getLexicalLevel() + 1));
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
            }
        }
        if ((pIn != null && pIn.length > 0 || pOut != null && pOut.length > 0) && (this.m_OutputMsgExpr != null || this.m_InputMsgExpr != null)) {
            VWString theMessage = new VWString("vw.api.VWInvokeInstructionInvalidParameterCombination", "Invoke instruction contains both parameters and input/output messages.");
            VWValidationError theError9 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
            validationContext.addValidationError(theError9);
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        int i;
        VWWebServiceParameterDefinition[] p;
        String ATTRIB_INDENT = "\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWInvokeInstructionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t<invoke\n");
        theBuffer.append(ATTRIB_INDENT + "Id=\"" + Integer.toString(this.getInstructionId()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Action=\"" + VWActionType.typeToString(this.getAction()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "partnerLink=\"" + VWXMLHandler.toXMLString(this.m_PartnerLinkName) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "operation=\"" + VWXMLHandler.toXMLString(this.m_OperationName) + "\"");
        if (this.m_InputMsgExpr != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "inputVariable=\"" + VWXMLHandler.toXMLString(this.m_InputMsgExpr) + "\"");
        }
        if (this.m_InputMsgName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "inputVariableName=\"" + VWXMLHandler.toXMLString(this.m_InputMsgName) + "\"");
        }
        if (this.m_OutputMsgExpr != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "outputVariable=\"" + VWXMLHandler.toXMLString(this.m_OutputMsgExpr) + "\"");
        }
        if (this.m_OutputMsgName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "outputVariableName=\"" + VWXMLHandler.toXMLString(this.m_OutputMsgName) + "\"");
        }
        if (this.m_TimeoutExpr != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "timeout=\"" + VWXMLHandler.toXMLString(this.m_TimeoutExpr) + "\"");
        }
        if (this.m_TimeoutMap != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "timeoutMap=\"" + VWXMLHandler.toXMLString(this.m_TimeoutMap) + "\"");
        }
        theBuffer.append("\n" + ATTRIB_INDENT + "useReliableMessaging=\"" + VWXMLHandler.booleanToString(this.m_UseReliableMessaging) + "\"");
        theBuffer.append(">\n");
        VWFaultDefinition[] faultArray = this.getFaults();
        if (faultArray != null) {
            for (int i2 = 0; i2 < faultArray.length; ++i2) {
                faultArray[i2].toXML(theBuffer);
            }
        }
        if (this.m_CatchAll != null) {
            theBuffer.append(ATTRIB_INDENT + "<catchAll>\n");
            this.m_CatchAll.toXML(theBuffer);
            theBuffer.append(ATTRIB_INDENT + "</catchAll>\n");
        }
        if ((p = this.getInComingParameterDefinitions()) != null) {
            theBuffer.append(ATTRIB_INDENT + "<InComingParameters>\n");
            for (i = 0; i < p.length; ++i) {
                p[i].toXML(theBuffer);
            }
            theBuffer.append(ATTRIB_INDENT + "</InComingParameters>\n");
        }
        if ((p = this.getOutGoingParameterDefinitions()) != null) {
            theBuffer.append(ATTRIB_INDENT + "<OutGoingParameters>\n");
            for (i = 0; i < p.length; ++i) {
                p[i].toXML(theBuffer);
            }
            theBuffer.append(ATTRIB_INDENT + "</OutGoingParameters>\n");
        }
        if (this.m_InputCorrelationSetName != null) {
            theBuffer.append(ATTRIB_INDENT + "<inputCorrelationSet>\n");
            theBuffer.append(ATTRIB_INDENT + "<correlationSet\n");
            ATTRIB_INDENT = ATTRIB_INDENT + "\t";
            theBuffer.append(ATTRIB_INDENT + "name=\"" + VWXMLHandler.toXMLString(this.m_InputCorrelationSetName) + "\">\n");
            if (this.m_InputCorrelationSetProperties != null) {
                for (i = 0; i < this.m_InputCorrelationSetProperties.length; ++i) {
                    theBuffer.append(ATTRIB_INDENT + "<property\n" + ATTRIB_INDENT + "\t" + "name=\"" + VWXMLHandler.toXMLString(this.m_InputCorrelationSetProperties[i][0]) + "\"\n" + ATTRIB_INDENT + "\t" + "query=\"" + VWXMLHandler.toXMLString(this.m_InputCorrelationSetProperties[i][1]) + "\" />\n");
                }
            }
            ATTRIB_INDENT = "\t\t\t\t";
            theBuffer.append(ATTRIB_INDENT + "</correlationSet>\n");
            theBuffer.append(ATTRIB_INDENT + "</inputCorrelationSet>\n");
        }
        if (this.m_OutputCorrelationSetName != null) {
            theBuffer.append(ATTRIB_INDENT + "<outputCorrelationSet>\n");
            theBuffer.append(ATTRIB_INDENT + "<correlationSet\n");
            ATTRIB_INDENT = ATTRIB_INDENT + "\t";
            theBuffer.append(ATTRIB_INDENT + "name=\"" + VWXMLHandler.toXMLString(this.m_OutputCorrelationSetName) + "\">\n");
            if (this.m_OutputCorrelationSetProperties != null) {
                for (i = 0; i < this.m_OutputCorrelationSetProperties.length; ++i) {
                    theBuffer.append(ATTRIB_INDENT + "<property\n" + ATTRIB_INDENT + "\t" + "name=\"" + VWXMLHandler.toXMLString(this.m_OutputCorrelationSetProperties[i][0]) + "\"\n" + ATTRIB_INDENT + "\t" + "query=\"" + VWXMLHandler.toXMLString(this.m_OutputCorrelationSetProperties[i][1]) + "\" />\n");
                }
            }
            ATTRIB_INDENT = "\t\t\t\t";
            theBuffer.append(ATTRIB_INDENT + "</correlationSet>\n");
            theBuffer.append(ATTRIB_INDENT + "</outputCorrelationSet>\n");
        }
        theBuffer.append("\t\t\t</invoke>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        int i;
        int i2;
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        String indentD = VWXMLHandler.incXMLIndent(indentC);
        String indentE = VWXMLHandler.incXMLIndent(indentD);
        String indentF = VWXMLHandler.incXMLIndent(indentE);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWInvokeInstructionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<TaskService Implementation=\"WebService\">\n");
        VWWebServiceParameterDefinition[] parameters = this.getOutGoingParameterDefinitions();
        if (parameters != null || this.m_OutputMsgExpr != null || this.m_OutputMsgName != null) {
            theBuffer.append(indentB + "<MessageIn Id=\"Outgoing\">\n");
            theBuffer.append(indentC + "<ActualParameters>\n");
            if (parameters != null) {
                for (i2 = 0; i2 < parameters.length; ++i2) {
                    parameters[i2].toXPDL(indentD, theBuffer);
                }
            } else {
                theBuffer.append(indentD + "<fn:ActualParameter");
                if (this.m_OutputMsgName != null) {
                    theBuffer.append(" fn:Name=\"" + VWXMLHandler.toXMLString(this.m_OutputMsgName) + "\"");
                }
                theBuffer.append(">");
                if (this.m_OutputMsgExpr != null) {
                    theBuffer.append(VWXMLHandler.toXMLString(this.m_OutputMsgExpr));
                }
                theBuffer.append("</fn:ActualParameter>\n");
            }
            theBuffer.append(indentC + "</ActualParameters>\n");
            theBuffer.append(indentB + "</MessageIn>\n");
        } else {
            theBuffer.append(indentB + "<MessageIn Id=\"Outgoing\"/>\n");
        }
        parameters = this.getInComingParameterDefinitions();
        if (parameters != null || this.m_InputMsgExpr != null || this.m_InputMsgName != null) {
            theBuffer.append(indentB + "<MessageOut Id=\"Incoming\">\n");
            theBuffer.append(indentC + "<ActualParameters>\n");
            if (parameters != null) {
                for (i2 = 0; i2 < parameters.length; ++i2) {
                    parameters[i2].toXPDL(indentD, theBuffer);
                }
            } else {
                theBuffer.append(indentD + "<fn:ActualParameter");
                if (this.m_InputMsgName != null) {
                    theBuffer.append(" fn:Name=\"" + VWXMLHandler.toXMLString(this.m_InputMsgName) + "\"");
                }
                theBuffer.append(">");
                if (this.m_InputMsgExpr != null) {
                    theBuffer.append(VWXMLHandler.toXMLString(this.m_InputMsgExpr));
                }
                theBuffer.append("</fn:ActualParameter>\n");
            }
            theBuffer.append(indentC + "</ActualParameters>\n");
            theBuffer.append(indentB + "</MessageOut>\n");
        } else {
            theBuffer.append(indentB + "<MessageOut Id=\"Incoming\"/>\n");
        }
        theBuffer.append(indentB + "<WebServiceOperation OperationName=\"" + VWXMLHandler.toXMLString(this.m_OperationName) + "\">\n");
        theBuffer.append(indentC + "<Partner PartnerLinkId=\"" + VWXMLHandler.toXMLString(this.m_PartnerLinkName) + "\" RoleType=\"PartnerRole\"/>\n");
        theBuffer.append(indentB + "</WebServiceOperation>\n");
        VWFaultDefinition[] faultArray = this.getFaults();
        if (faultArray != null) {
            for (i = 0; i < faultArray.length; ++i) {
                faultArray[i].toXPDL(indentB, theBuffer, false, this.getStep());
            }
        }
        if (this.m_CatchAll != null) {
            this.m_CatchAll.toXPDL(indentB, theBuffer, true, this.getStep());
        }
        theBuffer.append(indentB + "<fn:InvokeParameters Id=\"" + Integer.toString(this.getInstructionId()) + "\"");
        if (this.m_TimeoutExpr != null) {
            theBuffer.append("\n" + indentC + "timeout=\"" + VWXMLHandler.toXMLString(this.m_TimeoutExpr) + "\"");
        }
        if (this.m_TimeoutMap != null) {
            theBuffer.append("\n" + indentC + "timeoutMap=\"" + VWXMLHandler.toXMLString(this.m_TimeoutMap) + "\"");
        }
        theBuffer.append("\n" + indentC + "useReliableMessaging=\"" + VWXMLHandler.booleanToString(this.m_UseReliableMessaging) + "\">\n");
        if (this.m_InputCorrelationSetName != null) {
            theBuffer.append(indentC + "<inputCorrelationSet>\n");
            theBuffer.append(indentD + "<correlationSet name=\"" + VWXMLHandler.toXMLString(this.m_InputCorrelationSetName) + "\">\n");
            if (this.m_InputCorrelationSetProperties != null) {
                for (i = 0; i < this.m_InputCorrelationSetProperties.length; ++i) {
                    theBuffer.append(indentE + "<property name=\"" + VWXMLHandler.toXMLString(this.m_InputCorrelationSetProperties[i][0]) + "\"\n" + indentF + "query=\"" + VWXMLHandler.toXMLString(this.m_InputCorrelationSetProperties[i][1]) + "\"/>\n");
                }
            }
            theBuffer.append(indentD + "</correlationSet>\n");
            theBuffer.append(indentC + "</inputCorrelationSet>\n");
        }
        if (this.m_OutputCorrelationSetName != null) {
            theBuffer.append(indentC + "<outputCorrelationSet>\n");
            theBuffer.append(indentD + "<correlationSet name=\"" + VWXMLHandler.toXMLString(this.m_OutputCorrelationSetName) + "\">\n");
            if (this.m_OutputCorrelationSetProperties != null) {
                for (i = 0; i < this.m_OutputCorrelationSetProperties.length; ++i) {
                    theBuffer.append(indentE + "<property name=\"" + VWXMLHandler.toXMLString(this.m_OutputCorrelationSetProperties[i][0]) + "\"\n" + indentF + "query=\"" + VWXMLHandler.toXMLString(this.m_OutputCorrelationSetProperties[i][1]) + "\" />\n");
                }
            }
            theBuffer.append(indentD + "</correlationSet>\n");
            theBuffer.append(indentC + "</outputCorrelationSet>\n");
        }
        theBuffer.append(indentB + "</fn:InvokeParameters>\n");
        theBuffer.append(indentA + "</TaskService>\n");
    }

    public void setInputCorrelationSetName(String theName) throws VWException {
        int nMaxLength = 123;
        if (theName != null && theName.length() > nMaxLength) {
            throw new VWException("vw.api.VWInvokeInstructionInputCorrelationSetNameInvalidNameIsTooLong", "theName is invalid because it contains more than {0} characters.", nMaxLength);
        }
        if (theName != null) {
            for (int i = 1; i < theName.length(); ++i) {
                char c = theName.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                throw new VWException("vw.api.VWInvokeInstructionInputCorrelationSetNameInvalidNameBadCharacter", "Setting input correlation set name, theName is invalid because it contains an invalid character \"{0}\", the name can only contain letters, digits and underscore characters.", String.valueOf(c));
            }
        }
        this.m_InputCorrelationSetName = theName;
    }

    public String getInputCorrelationSetName() {
        return this.m_InputCorrelationSetName;
    }

    public void setOutputCorrelationSetName(String theName) throws VWException {
        int nMaxLength = 123;
        if (theName != null && theName.length() > nMaxLength) {
            throw new VWException("vw.api.VWInvokeInstructionOutputCorrelationSetNameInvalidNameIsTooLong", "theName is invalid because it contains more than {0} characters.", nMaxLength);
        }
        if (theName != null) {
            for (int i = 1; i < theName.length(); ++i) {
                char c = theName.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                throw new VWException("vw.api.VWInvokeInstructionOutputCorrelationSetNameInvalidNameBadCharacter", "Setting output correlation set name, theName is invalid because it contains an invalid character \"{0}\", the name can only contain letters, digits and underscore characters.", String.valueOf(c));
            }
        }
        this.m_OutputCorrelationSetName = theName;
    }

    public String getOutputCorrelationSetName() {
        return this.m_OutputCorrelationSetName;
    }

    public void setInputCorrelationSetProperties(String[][] theProps) throws VWException {
        if (theProps != null) {
            for (int i = 0; i < theProps.length; ++i) {
                if (theProps[i].length != 2) {
                    throw new VWException("vw.api.VWCorrelationSetPropertyArrayWrongDimension", "Correlation set property array wrong dimension, row {0} has {1} elements, should have 2 (representing the property name and property query of the correlation set property)", String.valueOf(i), String.valueOf(theProps[i].length));
                }
                if (theProps[i][0] != null && theProps[i][1] != null) continue;
                throw new VWException("vw.api.VWCorrelationSetPropertyArrayNullElement", "Correlation set property array contains a null entry in row {0}", String.valueOf(i));
            }
        }
        this.m_InputCorrelationSetProperties = theProps;
    }

    public String[][] getInputCorrelationSetProperties() {
        return this.m_InputCorrelationSetProperties;
    }

    public void setOutputCorrelationSetProperties(String[][] theProps) throws VWException {
        if (theProps != null) {
            for (int i = 0; i < theProps.length; ++i) {
                if (theProps[i].length != 2) {
                    throw new VWException("vw.api.VWCorrelationSetPropertyArrayWrongDimension", "Correlation set property array wrong dimension, row {0} has {1} elements, should have 2 (representing the property name and property query of the correlation set property)", String.valueOf(i), String.valueOf(theProps[i].length));
                }
                if (theProps[i][0] != null && theProps[i][1] != null) continue;
                throw new VWException("vw.api.VWCorrelationSetPropertyArrayNullElement", "Correlation set property array contains a null entry in row {0}", String.valueOf(i));
            }
        }
        this.m_OutputCorrelationSetProperties = theProps;
    }

    public String[][] getOutputCorrelationSetProperties() {
        return this.m_OutputCorrelationSetProperties;
    }

    public void setInputMsgName(String theInputMsgName) throws VWException {
        this.m_InputMsgName = theInputMsgName;
    }

    public String getInputMsgName() {
        return this.m_InputMsgName;
    }

    public void setOutputMsgName(String theOutputMsgName) throws VWException {
        this.m_OutputMsgName = theOutputMsgName;
    }

    public String getOutputMsgName() {
        return this.m_OutputMsgName;
    }

    public void setUseReliableMessaging(boolean theUseReliableMessagingFlag) throws VWException {
        this.m_UseReliableMessaging = theUseReliableMessagingFlag;
    }

    public boolean getUseReliableMessaging() throws VWException {
        return this.m_UseReliableMessaging;
    }
}

